/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.AliasElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.internal.core.index.JSIndexReader;
import com.aptana.js.internal.core.index.JSIndexWriter;
import com.aptana.js.internal.core.index.JSMetadataReader;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class SDocMLFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        if (context == null || index == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            sub.subTask(this.getIndexingMessage(index, context.getURI()));
            try {
                String typeName;
                JSMetadataReader reader = new JSMetadataReader();
                InputStream stream = context.openInputStream((IProgressMonitor)sub.newChild(5));
                reader.loadXML(stream, context.getURI().toString());
                sub.worked(45);
                JSIndexReader jsir = new JSIndexReader();
                List<TypeElement> globalTypes = jsir.getType(index, "Global", true);
                TypeElement globalTypeElement = !CollectionsUtil.isEmpty(globalTypes) ? globalTypes.get(globalTypes.size() - 1) : JSTypeUtil.createGlobalType("Global");
                JSIndexWriter indexer = new JSIndexWriter();
                TypeElement[] types = reader.getTypes();
                AliasElement[] aliases = reader.getAliases();
                URI location = context.getURI();
                Object[] objectArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeElement type = objectArray[n2];
                    type.setHasAllUserAgents();
                    for (PropertyElement property : type.getProperties()) {
                        property.setHasAllUserAgents();
                    }
                    typeName = type.getName();
                    if (!typeName.contains(".") && !typeName.startsWith("Class<")) {
                        List<FunctionElement> constructors = type.getConstructors();
                        if (!constructors.isEmpty()) {
                            for (FunctionElement constructor : constructors) {
                                type.removeProperty(constructor);
                                globalTypeElement.addProperty(constructor);
                            }
                            String newName = JSTypeUtil.toFunctionType(typeName);
                            type.setName(newName);
                            for (PropertyElement property : type.getProperties()) {
                                property.setOwningType(newName);
                            }
                        } else {
                            PropertyElement property = globalTypeElement.getProperty(typeName);
                            if (property == null) {
                                property = new PropertyElement();
                                property.setName(typeName);
                                property.addType(typeName);
                                property.setHasAllUserAgents();
                                globalTypeElement.addProperty(property);
                            }
                        }
                    }
                    indexer.writeType(index, type, location);
                    ++n2;
                }
                objectArray = aliases;
                n = aliases.length;
                n2 = 0;
                while (n2 < n) {
                    Object alias = objectArray[n2];
                    typeName = ((AliasElement)alias).getType();
                    PropertyElement property = globalTypeElement.getProperty(typeName);
                    if (property != null) {
                        property = property instanceof FunctionElement ? new FunctionElement((FunctionElement)property) : new PropertyElement(property);
                        property.setName(((AliasElement)alias).getName());
                    } else {
                        property = new PropertyElement();
                        property.setName(((AliasElement)alias).getName());
                        property.addType(typeName);
                    }
                    globalTypeElement.addProperty(property);
                    ++n2;
                }
                indexer.writeType(index, globalTypeElement, location);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            sub.done();
        }
    }
}

